% Model of a steady state isothermal plug flow reactor - Liquid phase

% Main file

% For more information, see:

% A. De Visscher 
% Lecture Notes in Chemical Engineering Kinetics and Chemical Reactor Design
% Createspace (2013) 

% (C) Alex De Visscher (2013)

% ---------------------------

% data

clear all

Wspan = 0:9.625:962.5; % We want output every 9.625 kg up to 962.5 kg
cE0 = 7;             % Initial alkene concentration (kmol/m3)
cH0 = 1;             % Initial hydrogen concentration (kmol/m3)
cA0 = 0;             % Initial alkane concentration (kmol/m3)

k2 = 1.1E-4;         % Rate constant (m4.5/kmol0.5/kg/s)
KE = 0.8;            % Rate constant (m3/kmol)
KH = 0.045;          % Rate constant (m3/kmol)
KA = 0.35;           % Rate constant (m3/kmol)
Q = 0.01;            % Volumetric flow rate (m3/s)

c0(1) = cH0;         % Running variable for cH is C(1)

% Call of differential equation solver

options = odeset('RelTol', 1e-6, 'AbsTol', 1e-8, 'InitialStep', 0.01);
[W,C] = ode45(@f,Wspan,c0,options,cE0,cH0,cA0,k2,KE,KH,KA,Q);

% Output

figure(1)
plot(W,C)
xlabel('Catalyst mass (kg)');
ylabel('Concentration of E (kmol/m3)');
W
C
[s1,s2] = size(W);
conversion = (C(1,1)-C(s1,1))/C(1,1)
